libname q 'c:\sascodeforbook\sasdatasets';
data first; set q.humandevelopment; 
	/*This syntax provides illustrative information that Chapter 5 discusses about the 
	first three uses for multilevel models*/
 
	/*This code provides a weight for the data*/	
sqrtpop =   sqrt(populat);

	/*This code makes a corruption typology*/
coruptyp = .;
if 1 le corrupt < 3 then coruptyp = 4;
if 3 le corrupt le 3.3 then coruptyp = 3;
if 3.4 le corrupt le 5 then coruptyp = 2;
if 5.01 le corrupt le 11 then coruptyp = 1;

	/*This code makes region typology*/
Fretyp99 = . ;
if free399 = 'F' then fretyp99 = 1;
if free399 = 'P' or free399 = 'PF' then fretyp99 = 2;
if free399 = 'NF' then fretyp99 = 3; 

	/*This code is used to create a flat file of 138 cases with no missing data*/
sregion = .;
if region = '01e' or region = '01m' or region = '01n' or region = '01s' or 
region = '01w' then sregion = 1;
if region = '02' then sregion = 1;
if region = '03c' or region = '03ca' or region = '03sa' or region = '04e' or
region = '04sc' or region = '04se' or region = '04w' then sregion = 1;
if region = '05e' or region = '05n' or region = '05s' or region = '05w' then sregion = 1;
if region = '06' then sregion = 1; 

sculture = .;
if culture = 'african' or culture = 'buddhist' or culture = 'hindu' or culture = 'islamic'
or culture = 'japan' or culture = 'latin' or culture = 'orthodox' or culture = 'sinic' or
culture = 'western' then sculture = 1;

sfretyp9 = .;
if fretyp99 ne . then sfretyp9 = 1;

sdebt = .;
if debt ne . then sdebt = 1;

sconflic = .;
if conflict ne . then sconflic = 1;

scorupt = .;
if coruptyp ne . then scorupt = 1;
    
sslave = .;
if slave98 ne . then sslave = 1;
 
fulslave = .;
if (slavery  ne . or slavery ne 0) then fulslave = 1;

shdirank = .;
if hdirank ne . then shdirank = 1;
		/*signal=1 will eliminate cases that have some missing data, so the data set has 138*/

signal = scorupt * sconflic * sdebt * sfretyp9 * sculture * sregion *sslave * shdirank;
run;


data explore; set first;
if signal = 1;  *there will be 138 cases;
revhdi = 183-hdirank;

LikeWest = .;
if culture = 'african' or culture = 'buddhist' or culture = 'hindu' or culture = 'islamic'
then LikeWest = 0;
If culture = 'japan' or culture = 'latin' or culture = 'orthodox' or culture = 'sinic' or
culture = 'western' then likewest = 1;

		*These codes dichotomize the instrumental freedom prerequisites as zero one indicators;
lodebt = 1;
if debt = 2 then lodebt = 0;
if debt = . then lodebt = .;

dichofre = 0;
if fretyp99 = 1 then dichofre = 1;
if fretyp99 = . then dichofre = .;

integrit = 0;
if coruptyp = 1 then integrit =1;
if coruptyp = . then integrit = .;

emancip = . ;
if slavery = 3 or slavery = 4 then emancip = 0;
if slavery = 1 or slavery = 2 then emancip = 1;

nochaos = 1;
if conflict = . then nochaos = .;
if conflict > 0 then nochaos = 0;

instfree = dichofre + integrit + emancip +lodebt + nochaos;

run;


data Undata; set explore;

/*These runs provide the data for the first three uses chapter four discusses.*/

/* This code produces data for the discussion of Use 1, Clustered Macro-Level Units.*/
Title 'Default REML	estimates';
proc mixed data= undata covtest ratio  cl=wald method = REML;
	class  region;
	model hdirank = /s ;
	random region/solution; 
	weight sqrtpop;
	parms/nobound;  
run;

Title 'Default Maximum Likelihoodestimates';
proc mixed data= undata covtest ratio  cl=wald method = ML;
	class  region;
	model hdirank = /s ;
	random region/solution; 
	weight sqrtpop;
	parms/nobound;  
run;

/* This code produces data for the discussion of Use 2, Significance of a Level-2 Variance.*/
/* The parms no bound statement implements a likelihood ratio test*/
Title 'Proc Mixed, Weights, No nesting  HDIRank, Dichotomized Factors, Random Region';
proc mixed data= undata covtest ratio  cl=Wald method=REML ;
	class  region culture;
	model hdirank = culture emancip dichofre lodebt nochaos integrit /solution;
	random region/solution;
	weight sqrtpop;
	parms/nobound;  
Run;

Title 'Proc Mixed, Weights, No nesting  HDIRank, Dichotomized Factors, Region not Random';
proc mixed data= undata covtest ratio  cl=Wald method=REML ;
	class  region culture;
	model hdirank = culture emancip dichofre lodebt nochaos integrit /solution;
	*random region/solution;
	weight sqrtpop;
	*parms/nobound;  
Run;


/* This code produces data for the discussion of Use 3, Accounting for a Level-2 Variance
by Classifying the Levels of the Random Variable*/

/* The estimate statements produce estimates depicted in Figure 5.1 and Figure 5.2*/
Title 'Proc Mixed, Weights, No nesting  HDIRank, Dichotomized Factors, Random Region';
proc mixed data= undata covtest ratio  cl=Wald method=REML ;
	class  region culture;
	model hdirank = culture emancip dichofre lodebt nochaos integrit /solution;
	random region/solution;
	weight sqrtpop;
	parms/nobound;  
estimate 'mean'		   intercept 1 | region 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1; 
estimate 'region 01e'  intercept 1 | region 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01m'  intercept 1 | region 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01n'  intercept 1 | region 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01s'  intercept 1 | region 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01w'  intercept 1 | region 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 02'   intercept 1 | region 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03c'  intercept 1 | region 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03ca' intercept 1 | region 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03sa' intercept 1 | region 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0;
estimate 'region 04e'  intercept 1 | region 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0;
estimate 'region 04sc' intercept 1 | region 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0;
estimate 'region 04se' intercept 1 | region 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0;
estimate 'region 04w'  intercept 1 | region 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0;
estimate 'region 05e'  intercept 1 | region 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0;
estimate 'region 05n'  intercept 1 | region 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0;
estimate 'region 05s'  intercept 1 | region 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0;
estimate 'region 05w'  intercept 1 | region 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0;
estimate 'region 06'   intercept 1 | region 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1;

estimate 'Umean'        | region 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1; 
estimate 'Uregion 01e'  | region 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01m'  | region 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01n'  | region 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01s'  | region 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uegion 01w'   | region 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 02'   | region 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03c'  | region 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03ca' | region 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03sa' | region 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 04e'  | region 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0;
estimate 'Uregion 04sc' | region 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0;
estimate 'Uregion 04se' | region 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0;
estimate 'Uregion 04w'  | region 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0;
estimate 'Uregion 05e'  | region 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0;
estimate 'Uregion 05n'  | region 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0;
estimate 'Uregion 05s'  | region 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0;
estimate 'Uregion 05w'  | region 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0;
estimate 'Uregion 06'   | region 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1;
run;

/* The estimate statements produce estimates depicted in Figure 5.1 and Figure 5.2*/
Title 'Proc Mixed, Weights, Nesting by dichofre, HDIRank, Dichotomized Factors,
	Nested Random Region';
proc mixed covtest ratio  cl=wald ;
	class  region culture dichofre;
	model hdirank = culture emancip dichofre lodebt nochaos integrit /s ;
	random region (dichofre)/solution; weight sqrtpop;
	parms/nobound;  *this statement changes the confidence intervals;
estimate 'mean'		   intercept 1 | region (dichofre)1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1;	
estimate 'region 01e'  intercept 1 | region (dichofre)1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01m'  intercept 1 | region (dichofre)0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01n'  intercept 1 | region (dichofre)0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01s'  intercept 1 | region (dichofre)0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01w'  intercept 1 | region (dichofre)0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 02'   intercept 1 | region (dichofre)0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03c'  intercept 1 | region (dichofre)0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03ca' intercept 1 | region (dichofre)0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03sa' intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0;
estimate 'region 04e'  intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0;
estimate 'region 04sc' intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0;
estimate 'region 04se' intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0;
estimate 'region 04w'  intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0;
estimate 'region 05e'  intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0;
estimate 'region 05n'  intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0;
estimate 'region 05s'  intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0;
estimate 'region 05w'  intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0;
estimate 'region 06'   intercept 1 | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1;
estimate 'mean'			 | region (dichofre)1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1; 
estimate 'Uregion 01e'   | region (dichofre)1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01m'   | region (dichofre)0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01n'   | region (dichofre)0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01s'   | region (dichofre)0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01w'   | region (dichofre)0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 02'    | region (dichofre)0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03c'   | region (dichofre)0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03ca'  | region (dichofre)0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03sa'  | region (dichofre)0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 04e'   | region (dichofre)0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0;
estimate 'Uregion 04sc'  | region (dichofre)0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0;
estimate 'Uregion 04se'  | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0;
estimate 'Uregion 04w'   | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0;
estimate 'Uregion 05e'   | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0;
estimate 'Uregion 05n'   | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0;
estimate 'Uregion 05s'   | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0;
estimate 'Uregion 05w'   | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0;
estimate 'Uregion 06'    | region (dichofre)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1;
run;

/* The estimate statements produce estimates depicted in Figure 5.1 and Figure 5.2*/
Title 'Proc Mixed, Weights, Nesting by dichofre and nochaos, HDIRank, Dichotomized Factors,
	Nested Random Region';
proc mixed covtest ratio  cl=wald ;
	class  region culture dichofre nochaos;
	model hdirank = culture emancip dichofre lodebt nochaos integrit /s ;
	random region (dichofre nochaos)/solution; weight sqrtpop;
	parms/nobound;  
estimate 'mean'		   intercept 1 | region (dichofre nochaos)1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1;	
estimate 'region 01e'  intercept 1 | region (dichofre nochaos)1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01m'  intercept 1 | region (dichofre nochaos)0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01n'  intercept 1 | region (dichofre nochaos)0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01s'  intercept 1 | region (dichofre nochaos)0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 01w'  intercept 1 | region (dichofre nochaos)0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 02'   intercept 1 | region (dichofre nochaos)0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03c'  intercept 1 | region (dichofre nochaos)0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03ca' intercept 1 | region (dichofre nochaos)0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0;
estimate 'region 03sa' intercept 1 | region (dichofre nochaos)0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0;
estimate 'region 04e'  intercept 1 | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0;
estimate 'region 04sc' intercept 1 | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0;
estimate 'region 04se' intercept 1 | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0;
estimate 'region 04w'  intercept 1 | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0;
estimate 'region 05e'  intercept 1 | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0;
estimate 'region 05n'  intercept 1 | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0;
estimate 'region 05s'  intercept 1 | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0;
estimate 'region 05w'  intercept 1 | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0;
estimate 'region 06'   intercept 1 | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1;
estimate 'mean'			 | region (dichofre nochaos)1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1; 
estimate 'Uregion 01e'   | region (dichofre nochaos)1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01m'   | region (dichofre nochaos)0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01n'   | region (dichofre nochaos)0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01s'   | region (dichofre nochaos)0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 01w'   | region (dichofre nochaos)0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 02'    | region (dichofre nochaos)0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03c'   | region (dichofre nochaos)0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03ca'  | region (dichofre nochaos)0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 03sa'  | region (dichofre nochaos)0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0;
estimate 'Uregion 04e'   | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0;
estimate 'Uregion 04sc'  | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0;
estimate 'Uregion 04se'  | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0;
estimate 'Uregion 04w'   | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0;
estimate 'Uregion 05e'   | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0;
estimate 'Uregion 05n'   | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0 0;
estimate 'Uregion 05s'   | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0;
estimate 'Uregion 05w'   | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0;
estimate 'Uregion 06'    | region (dichofre nochaos)0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1;
run;

/*This ends the code for Uses 1 to 3 of Chapter 5*/
/*The syntax in this file is copyright by Robert B. Smith  2011*/











































		





































